/* ============ */
/* pmtndefs.h	*/
/* ============ */
/* ==================================================================== */
/*        TYPEDEFS, #DEFINES AND PROTOTYPES FOR PERMUTATION TEST 	*/
/* ==================================================================== */
# if defined(__PMTNDEFS_H__)
#	/* Do Nothing */
# else
#	define	__PMTNDEFS_H__

# if !defined(__MISCDEFS_H__)

typedef	unsigned char		UCHAR;
typedef	unsigned int		UINT;
typedef	unsigned long		ULONG;

# if !defined(DEBUG)
#	define	P( F )
# else
#	define	P( F )	F
# endif

#define	SQR(x)	((x) * (x))

#define	FALSE	0
#define	TRUE	1
# endif

#define	MIN_CELL_CT	5
#define MAX_CELL_CT	10
#define	MAX_ELEMS	7
#define	MIN_ELEMS	3

/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */
# undef F
# if defined(__STDC__) || defined(__PROTO__)
#	define  F( P )  P
# else
#	define  F( P )  ()
# endif

/* INDENT OFF */
typedef	struct	PrmutDataStru
    {
	int	NumCategories;		/* No. Possible Outcomes	*/
	UINT	NumObs;			/* No. Groups to Analyze	*/
	int	NumElements;		/* No. Elements Per Group	*/
	int	CellExpectation;	/* No. Events per Category	*/
	long	NumVariates;		/* No. Variates Generated	*/
	double	PrmutChiSq;		/* Chi-Square Statistic		*/
	int	CallStatusOK;		/* 0 = FALSE, 1 = TRUE		*/
	int	(*RandFun) F((void));	/* Addr. of Generating Function	*/
    }
	PRMUT_DATA_STRU;

extern	int	AnalyzeNextPermutation	F((PRMUT_DATA_STRU *));
extern	void	CalcPermuteChiSq	F((PRMUT_DATA_STRU *));
extern	void	SetPermuteControls	F((PRMUT_DATA_STRU *));


# undef F
/* INDENT ON */

# endif				/* <<< __PMTNDEFS_H__ >>> */
